/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.model.loading;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.BlockStateResolver;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelResolver;
import net.fabricmc.fabric.impl.client.model.loading.BlockStateResolverHolder;
import net.fabricmc.fabric.impl.client.model.loading.LegacyModelVariantProvider;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoaderHooks;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoaderPluginContextImpl;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_773;
import net.minecraft.class_7775;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ModelLoadingEventDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelLoadingEventDispatcher.class);
    private final class_1088 loader;
    private final ModelLoaderPluginContextImpl pluginContext;
    private final ObjectArrayList<ModelResolverContext> modelResolverContextStack = new ObjectArrayList();
    private final ObjectArrayList<BlockStateResolverContext> blockStateResolverContextStack = new ObjectArrayList();
    private final ReferenceSet<class_2248> resolvingBlocks = new ReferenceOpenHashSet();
    private final ObjectArrayList<OnLoadModifierContext> onLoadModifierContextStack = new ObjectArrayList();
    private final ObjectArrayList<BeforeBakeModifierContext> beforeBakeModifierContextStack = new ObjectArrayList();
    private final ObjectArrayList<AfterBakeModifierContext> afterBakeModifierContextStack = new ObjectArrayList();

    public ModelLoadingEventDispatcher(class_1088 loader, List<ModelLoadingPlugin> plugins) {
        this.loader = loader;
        this.pluginContext = new ModelLoaderPluginContextImpl(((ModelLoaderHooks)loader)::fabric_getOrLoadModel);
        for (ModelLoadingPlugin plugin : plugins) {
            try {
                plugin.onInitializeModelLoader(this.pluginContext);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to initialize model loading plugin", (Throwable)exception);
            }
        }
    }

    public void addExtraModels(Consumer<class_2960> extraModelConsumer) {
        for (class_2960 id : this.pluginContext.extraModels) {
            extraModelConsumer.accept(id);
        }
    }

    public boolean loadModel(class_2960 id) {
        if (id instanceof class_1091) {
            class_1091 modelId = (class_1091)id;
            if ("inventory".equals(modelId.method_4740())) {
                this.loadItemModel(modelId);
                return true;
            }
            BlockStateResolverHolder resolver = this.pluginContext.getBlockStateResolver(modelId);
            if (resolver != null) {
                this.loadBlockStateModels(resolver.resolver(), resolver.block(), resolver.blockId());
                return true;
            }
            class_1100 legacyModel = this.legacyLoadModelVariant(modelId);
            if (legacyModel != null) {
                ((ModelLoaderHooks)this.loader).fabric_putModel(id, legacyModel);
                return true;
            }
            return false;
        }
        class_1100 model = this.resolveModel(id);
        if (model != null) {
            ((ModelLoaderHooks)this.loader).fabric_putModel(id, model);
            return true;
        }
        return false;
    }

    @Nullable
    private class_1100 legacyLoadModelVariant(class_1091 modelId) {
        return ((LegacyModelVariantProvider)this.pluginContext.legacyVariantProviders().invoker()).loadModelVariant(modelId);
    }

    private void loadItemModel(class_1091 modelId) {
        ModelLoaderHooks loaderHooks = (ModelLoaderHooks)this.loader;
        class_2960 id = modelId.method_45138("item/");
        class_1100 model = this.legacyLoadModelVariant(modelId);
        if (model == null) {
            model = this.resolveModel(id);
        }
        if (model == null) {
            model = loaderHooks.fabric_loadModelFromJson(id);
        }
        model = this.modifyModelOnLoad((class_2960)modelId, model);
        loaderHooks.fabric_putModelDirectly((class_2960)modelId, model);
        loaderHooks.fabric_putModelDirectly(id, model);
        loaderHooks.fabric_queueModelDependencies(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBlockStateModels(BlockStateResolver resolver, class_2248 block, class_2960 blockId) {
        if (!this.resolvingBlocks.add((Object)block)) {
            throw new IllegalStateException("Circular reference while resolving models for block " + String.valueOf(block));
        }
        try {
            this.resolveBlockStates(resolver, block, blockId);
        }
        finally {
            this.resolvingBlocks.remove((Object)block);
        }
    }

    private void resolveBlockStates(BlockStateResolver resolver, class_2248 block, class_2960 blockId) {
        if (this.blockStateResolverContextStack.isEmpty()) {
            this.blockStateResolverContextStack.add((Object)new BlockStateResolverContext());
        }
        BlockStateResolverContext context = (BlockStateResolverContext)this.blockStateResolverContextStack.pop();
        context.prepare(block);
        Reference2ReferenceMap<class_2680, class_1100> resolvedModels = context.models;
        ImmutableList allStates = block.method_9595().method_11662();
        boolean thrown = false;
        try {
            resolver.resolveBlockStates(context);
        }
        catch (Exception e) {
            LOGGER.error("Failed to resolve block state models for block {}. Using missing model for all states.", (Object)block, (Object)e);
            thrown = true;
        }
        if (thrown) {
            class_1100 missingModel = ((ModelLoaderHooks)this.loader).fabric_getMissingModel();
            for (class_2680 state2 : allStates) {
                class_1091 modelId = class_773.method_3336((class_2960)blockId, (class_2680)state2);
                ((ModelLoaderHooks)this.loader).fabric_putModelDirectly((class_2960)modelId, missingModel);
            }
        } else if (resolvedModels.size() == allStates.size()) {
            resolvedModels.forEach((state, model) -> {
                class_1091 modelId = class_773.method_3336((class_2960)blockId, (class_2680)state);
                ((ModelLoaderHooks)this.loader).fabric_putModel((class_2960)modelId, (class_1100)model);
            });
        } else {
            class_1100 missingModel = ((ModelLoaderHooks)this.loader).fabric_getMissingModel();
            for (class_2680 state3 : allStates) {
                class_1091 modelId = class_773.method_3336((class_2960)blockId, (class_2680)state3);
                @Nullable class_1100 model2 = (class_1100)resolvedModels.get((Object)state3);
                if (model2 == null) {
                    LOGGER.error("Block state resolver did not provide a model for state {} in block {}. Using missing model.", (Object)state3, (Object)block);
                    ((ModelLoaderHooks)this.loader).fabric_putModelDirectly((class_2960)modelId, missingModel);
                    continue;
                }
                ((ModelLoaderHooks)this.loader).fabric_putModel((class_2960)modelId, model2);
            }
        }
        resolvedModels.clear();
        this.blockStateResolverContextStack.add((Object)context);
    }

    @Nullable
    private class_1100 resolveModel(class_2960 id) {
        if (this.modelResolverContextStack.isEmpty()) {
            this.modelResolverContextStack.add((Object)new ModelResolverContext());
        }
        ModelResolverContext context = (ModelResolverContext)this.modelResolverContextStack.pop();
        context.prepare(id);
        class_1100 model = ((ModelResolver)this.pluginContext.resolveModel().invoker()).resolveModel(context);
        this.modelResolverContextStack.push((Object)context);
        return model;
    }

    public class_1100 modifyModelOnLoad(class_2960 id, class_1100 model) {
        if (this.onLoadModifierContextStack.isEmpty()) {
            this.onLoadModifierContextStack.add((Object)new OnLoadModifierContext());
        }
        OnLoadModifierContext context = (OnLoadModifierContext)this.onLoadModifierContextStack.pop();
        context.prepare(id);
        model = ((ModelModifier.OnLoad)this.pluginContext.modifyModelOnLoad().invoker()).modifyModelOnLoad(model, context);
        this.onLoadModifierContextStack.push((Object)context);
        return model;
    }

    public class_1100 modifyModelBeforeBake(class_1100 model, class_2960 id, Function<class_4730, class_1058> textureGetter, class_3665 settings, class_7775 baker) {
        if (this.beforeBakeModifierContextStack.isEmpty()) {
            this.beforeBakeModifierContextStack.add((Object)new BeforeBakeModifierContext());
        }
        BeforeBakeModifierContext context = (BeforeBakeModifierContext)this.beforeBakeModifierContextStack.pop();
        context.prepare(id, textureGetter, settings, baker);
        model = ((ModelModifier.BeforeBake)this.pluginContext.modifyModelBeforeBake().invoker()).modifyModelBeforeBake(model, context);
        this.beforeBakeModifierContextStack.push((Object)context);
        return model;
    }

    @Nullable
    public class_1087 modifyModelAfterBake(@Nullable class_1087 model, class_2960 id, class_1100 sourceModel, Function<class_4730, class_1058> textureGetter, class_3665 settings, class_7775 baker) {
        if (this.afterBakeModifierContextStack.isEmpty()) {
            this.afterBakeModifierContextStack.add((Object)new AfterBakeModifierContext());
        }
        AfterBakeModifierContext context = (AfterBakeModifierContext)this.afterBakeModifierContextStack.pop();
        context.prepare(id, sourceModel, textureGetter, settings, baker);
        model = ((ModelModifier.AfterBake)this.pluginContext.modifyModelAfterBake().invoker()).modifyModelAfterBake(model, context);
        this.afterBakeModifierContextStack.push((Object)context);
        return model;
    }

    @Environment(value=EnvType.CLIENT)
    private class BlockStateResolverContext
    implements BlockStateResolver.Context {
        private class_2248 block;
        private final Reference2ReferenceMap<class_2680, class_1100> models = new Reference2ReferenceOpenHashMap();

        private BlockStateResolverContext() {
        }

        private void prepare(class_2248 block) {
            this.block = block;
            this.models.clear();
        }

        @Override
        public class_2248 block() {
            return this.block;
        }

        @Override
        public void setModel(class_2680 state, class_1100 model) {
            Objects.requireNonNull(model, "state cannot be null");
            Objects.requireNonNull(model, "model cannot be null");
            if (!state.method_27852(this.block)) {
                throw new IllegalArgumentException("Attempted to set model for state " + String.valueOf(state) + " on block " + String.valueOf(this.block));
            }
            if (this.models.putIfAbsent((Object)state, (Object)model) != null) {
                throw new IllegalStateException("Duplicate model for state " + String.valueOf(state) + " on block " + String.valueOf(this.block));
            }
        }

        @Override
        public class_1100 getOrLoadModel(class_2960 id) {
            return ((ModelLoaderHooks)ModelLoadingEventDispatcher.this.loader).fabric_getOrLoadModel(id);
        }

        @Override
        public class_1088 loader() {
            return ModelLoadingEventDispatcher.this.loader;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class ModelResolverContext
    implements ModelResolver.Context {
        private class_2960 id;

        private ModelResolverContext() {
        }

        private void prepare(class_2960 id) {
            this.id = id;
        }

        @Override
        public class_2960 id() {
            return this.id;
        }

        @Override
        public class_1100 getOrLoadModel(class_2960 id) {
            return ((ModelLoaderHooks)ModelLoadingEventDispatcher.this.loader).fabric_getOrLoadModel(id);
        }

        @Override
        public class_1088 loader() {
            return ModelLoadingEventDispatcher.this.loader;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class OnLoadModifierContext
    implements ModelModifier.OnLoad.Context {
        private class_2960 id;

        private OnLoadModifierContext() {
        }

        private void prepare(class_2960 id) {
            this.id = id;
        }

        @Override
        public class_2960 id() {
            return this.id;
        }

        @Override
        public class_1100 getOrLoadModel(class_2960 id) {
            return ((ModelLoaderHooks)ModelLoadingEventDispatcher.this.loader).fabric_getOrLoadModel(id);
        }

        @Override
        public class_1088 loader() {
            return ModelLoadingEventDispatcher.this.loader;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class BeforeBakeModifierContext
    implements ModelModifier.BeforeBake.Context {
        private class_2960 id;
        private Function<class_4730, class_1058> textureGetter;
        private class_3665 settings;
        private class_7775 baker;

        private BeforeBakeModifierContext() {
        }

        private void prepare(class_2960 id, Function<class_4730, class_1058> textureGetter, class_3665 settings, class_7775 baker) {
            this.id = id;
            this.textureGetter = textureGetter;
            this.settings = settings;
            this.baker = baker;
        }

        @Override
        public class_2960 id() {
            return this.id;
        }

        @Override
        public Function<class_4730, class_1058> textureGetter() {
            return this.textureGetter;
        }

        @Override
        public class_3665 settings() {
            return this.settings;
        }

        @Override
        public class_7775 baker() {
            return this.baker;
        }

        @Override
        public class_1088 loader() {
            return ModelLoadingEventDispatcher.this.loader;
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class AfterBakeModifierContext
    implements ModelModifier.AfterBake.Context {
        private class_2960 id;
        private class_1100 sourceModel;
        private Function<class_4730, class_1058> textureGetter;
        private class_3665 settings;
        private class_7775 baker;

        private AfterBakeModifierContext() {
        }

        private void prepare(class_2960 id, class_1100 sourceModel, Function<class_4730, class_1058> textureGetter, class_3665 settings, class_7775 baker) {
            this.id = id;
            this.sourceModel = sourceModel;
            this.textureGetter = textureGetter;
            this.settings = settings;
            this.baker = baker;
        }

        @Override
        public class_2960 id() {
            return this.id;
        }

        @Override
        public class_1100 sourceModel() {
            return this.sourceModel;
        }

        @Override
        public Function<class_4730, class_1058> textureGetter() {
            return this.textureGetter;
        }

        @Override
        public class_3665 settings() {
            return this.settings;
        }

        @Override
        public class_7775 baker() {
            return this.baker;
        }

        @Override
        public class_1088 loader() {
            return ModelLoadingEventDispatcher.this.loader;
        }
    }
}

